import 'dart:math';

class AppUtils {
  static int intVal(dynamic value) {
    switch (value.runtimeType) {
      case int:
        return value;

      case double:
        return int.parse(value.toString());

      case String:
      default:
        return int.parse(value);
    }
  }

  static String random([int length = 6]) {
    var cSet = 'AaBbCcDdEeFfGgHhIiJjKkLlMmNnOoPpQqRrSsTtUuVvWwXxYyZz1234567890';

    return String.fromCharCodes(
      Iterable.generate(
        length,
        (_) => cSet.codeUnitAt(
          (Random()).nextInt(
            cSet.length,
          ),
        ),
      ),
    );
  }
}
